﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;

using NAudio.Wave;
using NAudio.FileFormats;
using NAudio.CoreAudioApi;
using NAudio;

namespace Avi
{
    public class AudioDevice: IDisposable {

        WaveIn waveIn;
        //Класс для записи в файл
        //Имя файла для записи
        public AudioDevice(EventHandler<WaveInEventArgs> DataAvailable, EventHandler<StoppedEventArgs> RecordingStopped)
        {
            try {//
                waveIn = new WaveIn();
                //Дефолтное устройство для записи (если оно имеется)
                waveIn.DeviceNumber = 0;
               //Прикрепляем к событию DataAvailable обработчик, возникающий при наличии записываемых данных
                waveIn.DataAvailable += DataAvailable;
                //Прикрепляем обработчик завершения записи
                waveIn.RecordingStopped += RecordingStopped;
                //Формат wav-файла - принимает параметры - частоту дискретизации и количество каналов(здесь mono)
                waveIn.WaveFormat = new WaveFormat(44100, 2);
                //Инициализируем объект WaveFileWriter
                 //Начало записи
                waveIn.StartRecording();
            }  catch (Exception ex) { 
                MessageBox.Show(ex.Message);
            }
        }

        ~AudioDevice()
        {
            Dispose(false);
        }
        public void Dispose() {
            Dispose(true);
            GC.SuppressFinalize(this);
        }

        void Dispose(bool disposing)
        {

            //waveIn.Dispose();
            waveIn = null;
        }

    }



}

